/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.model.animation;

import java.util.Map;
import java.util.TreeMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.entity.data.IEmotion;
import noppes.npcs.api.entity.data.IEmotionPart;
import noppes.npcs.client.model.animation.EmotionFrame;

public class EmotionConfig
implements IEmotion {
    public static final EmotionConfig EMPTY = new EmotionConfig();
    public final Map<Integer, EmotionFrame> frames;
    public int id = 0;
    public int repeatLast = 0;
    public String name = "Default Emotion";
    public boolean canBlink = true;
    public boolean immutable = false;
    public boolean isEdit = false;
    public final Map<Integer, Integer> endingFrameTicks = new TreeMap<Integer, Integer>();
    public int totalTicks = 0;
    public int editFrame = -1;
    public float scaleMoveX = 1.0f;
    public float scaleMoveY = 1.0f;

    public EmotionConfig() {
        this.frames = new TreeMap<Integer, EmotionFrame>();
        this.frames.put(0, new EmotionFrame(0));
    }

    public void read(NBTTagCompound nbtEmotion) {
        this.frames.clear();
        for (int i = 0; i < nbtEmotion.func_150295_c("FrameConfigs", 10).func_74745_c(); ++i) {
            EmotionFrame ef = new EmotionFrame(i);
            ef.readFromNBT(nbtEmotion.func_150295_c("FrameConfigs", 10).func_150305_b(i));
            ef.id = i;
            this.frames.put(i, ef);
        }
        if (this.frames.isEmpty()) {
            this.frames.put(0, new EmotionFrame(0));
        }
        this.id = nbtEmotion.func_74762_e("ID");
        this.name = nbtEmotion.func_74779_i("Name");
        this.repeatLast = nbtEmotion.func_74762_e("EmotionRepeat");
        this.canBlink = nbtEmotion.func_74767_n("CanBlink");
        if (nbtEmotion.func_150297_b("ScaleMoveX", 5)) {
            this.scaleMoveX = Math.max(0.05f, Math.min(1.25f, nbtEmotion.func_74760_g("ScaleMoveX")));
        }
        if (nbtEmotion.func_150297_b("ScaleMoveY", 5)) {
            this.scaleMoveY = Math.max(0.05f, Math.min(1.25f, nbtEmotion.func_74760_g("ScaleMoveY")));
        }
    }

    public NBTTagCompound save() {
        NBTTagCompound nbtEmotion = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (EmotionFrame ef : this.frames.values()) {
            list.func_74742_a((NBTBase)ef.writeToNBT());
        }
        nbtEmotion.func_74782_a("FrameConfigs", (NBTBase)list);
        nbtEmotion.func_74768_a("ID", this.id);
        nbtEmotion.func_74778_a("Name", this.name);
        nbtEmotion.func_74768_a("EmotionRepeat", this.repeatLast);
        nbtEmotion.func_74757_a("CanBlink", this.canBlink);
        if (this.repeatLast < 0) {
            this.repeatLast = this.frames.size() - 1;
        }
        nbtEmotion.func_74776_a("ScaleMoveX", this.scaleMoveX);
        nbtEmotion.func_74776_a("ScaleMoveY", this.scaleMoveY);
        return nbtEmotion;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public EmotionConfig copy() {
        EmotionConfig ec = new EmotionConfig();
        ec.read(this.save());
        ec.resetTicks();
        return ec;
    }

    public String getSettingName() {
        String c = "\u00a7";
        return c + "7" + this.id + ": " + c + "r" + this.name;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public boolean canBlink() {
        return this.canBlink;
    }

    @Override
    public void setCanBlink(boolean bo) {
        this.canBlink = bo;
    }

    @Override
    public IEmotionPart addFrame() {
        int f = this.frames.size();
        this.frames.put(f, new EmotionFrame(f));
        return this.frames.get(f);
    }

    @Override
    public IEmotionPart addFrame(IEmotionPart frame) {
        if (frame == null) {
            return this.addFrame();
        }
        int f = this.frames.size();
        this.frames.put(f, ((EmotionFrame)frame).copy());
        this.frames.get((Object)Integer.valueOf((int)f)).id = f;
        return this.frames.get(f);
    }

    @Override
    public boolean removeFrame(IEmotionPart frame) {
        if (frame == null || this.frames.size() <= 1) {
            return false;
        }
        for (int f : this.frames.keySet()) {
            if (!this.frames.get(f).equals(frame)) continue;
            this.removeFrame(f);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeFrame(int frameId) {
        if (this.frames.size() <= 1) {
            return false;
        }
        if (!this.frames.containsKey(frameId)) {
            throw new CustomNPCsException("Unknown frame ID:" + frameId, new Object[0]);
        }
        TreeMap<Integer, EmotionFrame> newData = new TreeMap<Integer, EmotionFrame>();
        int i = 0;
        boolean isDel = false;
        for (int f : this.frames.keySet()) {
            if (f == frameId) {
                isDel = true;
                continue;
            }
            newData.put(i, this.frames.get(f).copy());
            ((EmotionFrame)newData.get((Object)Integer.valueOf((int)i))).id = i;
            ++i;
        }
        if (isDel) {
            this.frames.clear();
            if (newData.isEmpty()) {
                newData.put(0, new EmotionFrame(0));
            }
            this.frames.putAll(newData);
        }
        return isDel;
    }

    public void resetTicks() {
        this.totalTicks = 0;
        this.endingFrameTicks.clear();
        if (this == EMPTY) {
            this.totalTicks = EmotionFrame.EMPTY.speed + EmotionFrame.EMPTY.delay + 1;
            this.endingFrameTicks.put(0, this.totalTicks);
            return;
        }
        for (Integer id : this.frames.keySet()) {
            EmotionFrame frame = this.frames.get(id);
            if (frame.speed < 1) {
                frame.speed = 1;
            }
            this.totalTicks += frame.speed + frame.delay;
            this.endingFrameTicks.put(id, this.totalTicks);
        }
        if (this.totalTicks == 0) {
            this.totalTicks = 1;
        }
    }

    public int getEmotionFrameByTime(int ticks) {
        if (ticks >= 0) {
            if (this.endingFrameTicks.isEmpty() && !this.frames.isEmpty()) {
                this.resetTicks();
            }
            for (int id : this.endingFrameTicks.keySet()) {
                if (ticks > this.endingFrameTicks.get(id)) continue;
                return id;
            }
            return this.frames.size();
        }
        return -1;
    }

    static {
        EmotionConfig.EMPTY.frames.put(0, EmotionFrame.EMPTY);
        EMPTY.resetTicks();
    }
}

